/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest;

import junit.framework.TestCase;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMatcherTest
extends TestCase {
    protected abstract Matcher<?> createMatcher();

    public static <T> void assertMatches(String message, Matcher<? super T> c, T arg) {
        Assert.assertTrue((String)message, (boolean)c.matches(arg));
    }

    public static <T> void assertDoesNotMatch(String message, Matcher<? super T> c, T arg) {
        Assert.assertFalse((String)message, (boolean)c.matches(arg));
    }

    public static void assertDescription(String expected, Matcher<?> matcher) {
        StringDescription description = new StringDescription();
        description.appendDescriptionOf(matcher);
        Assert.assertEquals((String)"Expected description", (Object)expected, (Object)description.toString().trim());
    }

    public static <T> void assertMismatchDescription(String expected, Matcher<? super T> matcher, T arg) {
        Assert.assertFalse((String)"Precondtion: Matcher should not match item.", (boolean)matcher.matches(arg));
        StringDescription description = new StringDescription();
        matcher.describeMismatch(arg, (Description)description);
        Assert.assertEquals((String)"Expected mismatch description", (Object)expected, (Object)description.toString().trim());
    }

    public void testIsNullSafe() {
        this.createMatcher().matches(null);
    }

    public void testCopesWithUnknownTypes() {
        this.createMatcher().matches((Object)new UnknownType());
    }

    public static class UnknownType {
    }
}

